﻿//////////////////////////////////////////////
// SsaoProgramTracker.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkAstraeus
#include "../../Utils/ProgramTracker.h"

#include "SsaoEffectInfo.h"

/// Internals --------------------------------

namespace nkAstraeus
{
	struct SsaoProgramIdGenerator
	{
		static unsigned long long generate (const SsaoEffectInfo& info) ;
	} ;

	struct SsaoProgramNameGenerator
	{
		constexpr static const char* name = "NILKINS_SSAO_PROGRAM_" ;
	} ;
}

/// Class ------------------------------------

namespace nkAstraeus
{
	class SsaoProgramTracker final : public ProgramTracker<SsaoEffectInfo, SsaoProgramIdGenerator, SsaoProgramNameGenerator>
	{
		public :

			// Functions
			// Constructor, destructor
			SsaoProgramTracker (nkGraphics::System* graphicsSystem) noexcept ;
			virtual ~SsaoProgramTracker () ;
	} ;
}